/*
 * Decompiled with CFR 0.152.
 */
package pl.itcrowd.jbossas.login_module.token;

import java.security.Principal;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.jboss.security.auth.spi.DatabaseServerLoginModule;

public class TokenLoginModule
extends DatabaseServerLoginModule {
    private char[] credential;
    private Principal identity;

    public boolean login() throws LoginException {
        if (this.superLogin()) {
            Object username = this.sharedState.get("javax.security.auth.login.name");
            if (username instanceof Principal) {
                this.identity = (Principal)username;
            } else {
                String name = username.toString();
                try {
                    this.identity = this.createIdentity(name);
                }
                catch (Exception e) {
                    this.log.debug((Object)"Failed to create principal", (Throwable)e);
                    throw new LoginException("PB00019: Processing Failed:Failed to create principal: " + e.getMessage());
                }
            }
            Object password = this.sharedState.get("javax.security.auth.login.password");
            if (password instanceof char[]) {
                this.credential = (char[])password;
            } else if (password != null) {
                String tmp = password.toString();
                this.credential = tmp.toCharArray();
            }
            return true;
        }
        this.loginOk = false;
        String[] info = this.getUsernameAndPassword();
        String username = info[0];
        String password = info[1];
        if (username == null && password == null) {
            this.identity = this.unauthenticatedIdentity;
            this.log.trace((Object)("Authenticating as unauthenticatedIdentity=" + this.identity));
        } else if (!"token".equalsIgnoreCase(username)) {
            throw new LoginException("PB00024: Access Denied:Invalid username: " + username);
        }
        if (this.identity == null) {
            try {
                this.identity = this.createIdentity(password);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to create principal", (Throwable)e);
                throw new LoginException("PB00019: Processing Failed:Failed to create principal: " + e.getMessage());
            }
            String expectedUsername = this.getUsersPassword();
            if (null == expectedUsername) {
                Throwable ex = this.getValidateError();
                FailedLoginException fle = new FailedLoginException("Token Incorrect");
                if (ex != null) {
                    this.log.debug((Object)("Bad password for username=" + username), ex);
                    fle.initCause(ex);
                } else {
                    this.log.debug((Object)("Bad password for username=" + username));
                }
                throw fle;
            }
            this.credential = null == password ? new char[]{} : password.toCharArray();
            try {
                this.identity = this.createIdentity(expectedUsername);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to create principal", (Throwable)e);
                throw new LoginException("PB00019: Processing Failed:Failed to create principal: " + e.getMessage());
            }
        }
        if (this.getUseFirstPass()) {
            this.sharedState.put("javax.security.auth.login.name", this.identity);
            this.sharedState.put("javax.security.auth.login.password", this.credential);
        }
        this.loginOk = true;
        this.log.trace((Object)("User '" + this.identity + "' authenticated, loginOk=" + this.loginOk));
        return true;
    }

    protected Principal getIdentity() {
        return this.identity;
    }

    private boolean superLogin() {
        if (this.trace) {
            this.log.trace((Object)"login");
        }
        this.loginOk = false;
        if (this.useFirstPass) {
            try {
                Object identity = this.sharedState.get("javax.security.auth.login.name");
                Object credential = this.sharedState.get("javax.security.auth.login.password");
                if (identity != null && credential != null) {
                    this.loginOk = true;
                    return true;
                }
            }
            catch (Exception e) {
                this.log.error((Object)"login failed", (Throwable)e);
            }
        }
        return false;
    }
}

