package pl.itcrowd.jbossas.login_module.token;

import org.jboss.security.ErrorCodes;
import org.jboss.security.auth.spi.DatabaseServerLoginModule;

import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import java.security.Principal;

public class TokenLoginModule extends DatabaseServerLoginModule {

    /**
     * The proof of login identity
     */
    private char[] credential;

    private Principal identity;

    @Override
    public boolean login() throws LoginException
    {
        // See if shared credentials exist
        if (superLogin()) {
            // Setup our view of the user
            Object username = sharedState.get("javax.security.auth.login.name");
            if (username instanceof Principal) {
                identity = (Principal) username;
            } else {
                String name = username.toString();
                try {
                    identity = createIdentity(name);
                } catch (Exception e) {
                    log.debug("Failed to create principal", e);
                    throw new LoginException(ErrorCodes.PROCESSING_FAILED + "Failed to create principal: " + e.getMessage());
                }
            }
            Object password = sharedState.get("javax.security.auth.login.password");
            if (password instanceof char[]) {
                credential = (char[]) password;
            } else if (password != null) {
                String tmp = password.toString();
                credential = tmp.toCharArray();
            }
            return true;
        }

        super.loginOk = false;
        String[] info = getUsernameAndPassword();
        String username = info[0];
        String password = info[1];


        if (username == null && password == null) {
            identity = unauthenticatedIdentity;
            super.log.trace("Authenticating as unauthenticatedIdentity=" + identity);
        } else if(!"token".equalsIgnoreCase(username)){
            throw new LoginException(ErrorCodes.ACCESS_DENIED + "Invalid username: " + username);
        }

        if (identity == null) {
            try {
                identity = createIdentity(password);
            } catch (Exception e) {
                log.debug("Failed to create principal", e);
                throw new LoginException(ErrorCodes.PROCESSING_FAILED + "Failed to create principal: " + e.getMessage());
            }

            // Validate the password supplied by the subclass
            String expectedUsername = getUsersPassword();
            //Check if the password is vaultified
            if (null == expectedUsername) {
                Throwable ex = getValidateError();
                FailedLoginException fle = new FailedLoginException("Token Incorrect");
                if (ex != null) {
                    log.debug("Bad password for username=" + username, ex);
                    fle.initCause(ex);
                } else {
                    log.debug("Bad password for username=" + username);
                }
                throw fle;
            } else {
                credential= null == password ? new char[0] : password.toCharArray();
            }
            try {
                identity = createIdentity(expectedUsername);
            } catch (Exception e) {
                log.debug("Failed to create principal", e);
                throw new LoginException(ErrorCodes.PROCESSING_FAILED + "Failed to create principal: " + e.getMessage());
            }
        }

        if (getUseFirstPass()) {    // Add the principal and password to the shared state map
            sharedState.put("javax.security.auth.login.name", identity);
            sharedState.put("javax.security.auth.login.password", credential);
        }
        super.loginOk = true;
        super.log.trace("User '" + identity + "' authenticated, loginOk=" + loginOk);
        return true;
    }

    @Override
    protected Principal getIdentity()
    {
        return identity;
    }

    private boolean superLogin()
    {
        if (trace) {
            log.trace("login");
        }
        loginOk = false;
        // If useFirstPass is true, look for the shared password
        if (useFirstPass) {
            try {
                Object identity = sharedState.get("javax.security.auth.login.name");
                Object credential = sharedState.get("javax.security.auth.login.password");
                if (identity != null && credential != null) {
                    loginOk = true;
                    return true;
                }
                // Else, fall through and perform the login
            } catch (Exception e) {   // Dump the exception and continue
                log.error("login failed", e);
            }
        }
        return false;
    }
}
