/*
 * Decompiled with CFR 0.152.
 */
package pl.com.it_crowd.utils.config;

import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import pl.com.it_crowd.utils.config.InvalidConfigurationException;
import pl.com.it_crowd.utils.config.PBEHelper;
import pl.com.it_crowd.utils.config.PBESpec;
import pl.com.it_crowd.utils.config.Setting;
import pl.com.it_crowd.utils.config.SettingDAO;
import pl.com.it_crowd.utils.config.converter.SettingConverter;

public abstract class ApplicationConfig {
    protected PBEHelper pbeHelper;
    @Inject
    protected Instance<PBESpec> pbeSpecInstance;
    @Inject
    protected SettingDAO settingDAO;

    @PostConstruct
    protected void init() {
        PBESpec spec = (PBESpec)this.pbeSpecInstance.get();
        this.pbeHelper = new PBEHelper(spec.getAlgorithm(), spec.getPassword(), spec.getSalt(), spec.getIterationCount());
    }

    protected String load(Enum id) {
        return this.load(id.name());
    }

    protected String load(String id) {
        Setting setting = this.settingDAO.load(id);
        if (setting == null) {
            throw new InvalidConfigurationException(String.format("Missing %s setting", id));
        }
        return setting.getValue();
    }

    protected <T> T load(String id, SettingConverter<T> converter) {
        String stringValue = this.load(id);
        return converter.getObject(stringValue);
    }

    protected <T> T load(Enum id, SettingConverter<T> converter) {
        return this.load(id.name(), converter);
    }

    protected boolean save(Setting setting) {
        return this.save(setting, null);
    }

    protected boolean save(Setting setting, String encryptionKey) {
        if (encryptionKey != null) {
            setting.setValue(this.pbeHelper.encrypt(setting.getValue()));
        }
        this.settingDAO.save(setting);
        return true;
    }

    protected boolean save(String id, String value) {
        return this.save(new Setting(id, value), null);
    }

    protected boolean save(Enum id, String value) {
        return this.save(id.name(), value);
    }

    protected boolean save(String id, String value, String encryptionKey) {
        return this.save(new Setting(id, value), encryptionKey);
    }

    protected boolean save(Enum id, String value, String encryptionKey) {
        return this.save(id.name(), value, encryptionKey);
    }
}

