/*
 * Decompiled with CFR 0.152.
 */
package pl.com.it_crowd.utils.config;

import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.binary.Hex;

public class PBEHelper {
    private static final String CHARSET_NAME = "UTF8";
    private Cipher cipher;
    private Cipher ecipher;

    public PBEHelper(String encryptionAlgorithm, String passPhrase, String salt, int iterationCount) {
        try {
            PBEKeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray(), this.toSalt(salt), iterationCount);
            SecretKey key = SecretKeyFactory.getInstance(encryptionAlgorithm).generateSecret(keySpec);
            this.ecipher = Cipher.getInstance(key.getAlgorithm());
            this.cipher = Cipher.getInstance(key.getAlgorithm());
            PBEParameterSpec paramSpec = new PBEParameterSpec(this.toSalt(salt), iterationCount);
            this.ecipher.init(1, (Key)key, paramSpec);
            this.cipher.init(2, (Key)key, paramSpec);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Cannot initialize PBEHelper", e);
        }
    }

    public String decrypt(String str) {
        try {
            byte[] dec = Hex.decodeHex((char[])str.toCharArray());
            return new String(this.cipher.doFinal(dec), CHARSET_NAME);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Problems during decrypting", e);
        }
    }

    public String encrypt(String str) {
        try {
            byte[] bytes = str.getBytes(CHARSET_NAME);
            return Hex.encodeHexString((byte[])this.ecipher.doFinal(bytes));
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Problems during encrypting", e);
        }
    }

    private byte[] toSalt(String phrase) {
        return Arrays.copyOf(phrase.getBytes(), 8);
    }
}

