/*
 * Decompiled with CFR 0.152.
 */
package pl.com.it_crowd.utils.test;

import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.logging.Logger;
import org.junit.Rule;
import org.junit.rules.TestWatchman;
import org.junit.runners.model.FrameworkMethod;
import org.unitils.core.Unitils;
import org.unitils.core.dbsupport.DefaultSQLHandler;
import org.unitils.core.dbsupport.SQLHandler;
import org.unitils.database.DatabaseModule;
import org.unitils.dbmaintainer.clean.DBCleaner;
import org.unitils.dbmaintainer.util.DatabaseModuleConfigUtils;

public class UnitilsAwareTest {
    private Logger logger = Logger.getLogger(this.getClass());
    @Rule
    public TestWatchman unitilsLuncher = new TestWatchman(){

        public void starting(FrameworkMethod method) {
            UnitilsAwareTest.this.logger.info((Object)("Starting test " + method.getName()));
            if (this.isOnServer()) {
                return;
            }
            Unitils unitils = Unitils.getInstance();
            Properties configuration = unitils.getConfiguration();
            configuration.setProperty("dbMaintainer.keepRetryingAfterError.enabled", "TRUE");
            DataSource dataSource = ((DatabaseModule)unitils.getModulesRepository().getModuleOfType(DatabaseModule.class)).getDataSourceAndActivateTransactionIfNeeded();
            DefaultSQLHandler handler = new DefaultSQLHandler(dataSource);
            ((DBCleaner)DatabaseModuleConfigUtils.getConfiguredDatabaseTaskInstance(DBCleaner.class, (Properties)configuration, (SQLHandler)handler)).cleanSchemas();
            Unitils.getInstance().getTestListener().beforeTestSetUp((Object)UnitilsAwareTest.this, method.getMethod());
            Unitils.getInstance().getTestListener().beforeTestMethod((Object)UnitilsAwareTest.this, method.getMethod());
        }

        private boolean isOnServer() {
            return null == ((Object)((Object)this)).getClass().getResource("/unitils.properties");
        }

        public void finished(FrameworkMethod method) {
            if (this.isOnServer()) {
                return;
            }
            Unitils.getInstance().getTestListener().afterTestMethod((Object)UnitilsAwareTest.this, method.getMethod(), null);
            Unitils.getInstance().getTestListener().afterTestTearDown((Object)UnitilsAwareTest.this, method.getMethod());
        }
    };
}

