/*
 * Decompiled with CFR 0.152.
 */
package pl.com.it_crowd.utils.test;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableDataCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public final class WebClientUtils {
    private static long defaultCheckInterval = 500L;
    private static long defaultTimeout = 10000L;

    public static boolean contains(HtmlTable table, int cellNumber, String searchedText) {
        List<HtmlTableRow> rows = WebClientUtils.getTableRows(table);
        for (HtmlTableRow row : rows) {
            if (!row.getCell(cellNumber).getTextContent().contains(searchedText)) continue;
            return true;
        }
        return false;
    }

    public static void executeAjaxReRenderedScripts(HtmlPage page) {
        DomNodeList scripts = page.getElementsByTagName("script");
        ArrayList<HtmlElement> scriptsList = new ArrayList<HtmlElement>();
        for (HtmlElement element : scripts) {
            scriptsList.add(element);
        }
        for (HtmlElement element : scriptsList) {
            if (element.getChildNodes().size() <= 1) continue;
            element.removeChild((Node)element.getFirstChild());
            DomNode sibling = element.getNextSibling();
            DomNode parentNode = element.getParentNode();
            if (sibling != null) {
                parentNode.removeChild((Node)element);
                sibling.insertBefore((DomNode)element);
                continue;
            }
            parentNode.removeChild((Node)element);
            parentNode.appendChild((Node)element);
        }
    }

    public static void forceWait(int timeout) {
        long startTime = System.currentTimeMillis();
        do {
            try {
                long millis = startTime + (long)timeout - System.currentTimeMillis();
                if (millis <= 0L) continue;
                Thread.sleep(millis);
            }
            catch (InterruptedException ignore) {
            }
            catch (IllegalArgumentException ignore) {
                // empty catch block
            }
        } while (startTime + (long)timeout > System.currentTimeMillis());
    }

    public static long getDefaultCheckInterval() {
        return defaultCheckInterval;
    }

    public static long getDefaultTimeout() {
        return defaultTimeout;
    }

    public static HtmlTableDataCell getScheduleDayCell(HtmlElement schedule, int dayOfMonth) {
        return (HtmlTableDataCell)schedule.getByXPath(".//td[contains(@class,'fc-day') and not(contains(@class,'fc-other-month'))]").get(dayOfMonth - 1);
    }

    public static List<HtmlSpan> getScheduleEventTitles(HtmlElement schedule) {
        return schedule.getByXPath(".//*[@class='fc-event-title']");
    }

    public static Map<String, HtmlTableCell> getSuggestions(HtmlElement suggestion, int column) {
        HashMap<String, HtmlTableCell> suggestions = new HashMap<String, HtmlTableCell>();
        HtmlElement suggestElement = suggestion.getElementById(suggestion.getId() + ":suggest");
        DomNodeList suggestionRows = suggestElement.getElementsByTagName("tr");
        for (HtmlElement row : suggestionRows) {
            if (row.getId().endsWith("NothingLabel")) continue;
            DomNodeList cells = row.getElementsByTagName("td");
            HtmlTableCell cell = (HtmlTableCell)cells.get(column + 1);
            suggestions.put(cell.asText(), cell);
        }
        return suggestions;
    }

    public static List<HtmlTableRow> getTableRows(HtmlTable table) {
        return table.getByXPath(".//*[contains(@class,'rf-dt-r')]");
    }

    public static void setDefaultCheckInterval(long defaultCheckInterval) {
        WebClientUtils.defaultCheckInterval = defaultCheckInterval;
    }

    public static void setDefaultTimeout(long defaultTimeout) {
        WebClientUtils.defaultTimeout = defaultTimeout;
    }

    public static int waitForJSJob(String message, WebClient webClient) {
        return WebClientUtils.waitForJSJob(message, webClient, webClient.waitForBackgroundJavaScript(10L) - 1);
    }

    public static int waitForJSJob(String message, WebClient webClient, int initialJobCount) {
        return WebClientUtils.waitForJSJob(message, webClient, initialJobCount, defaultTimeout);
    }

    public static int waitForJSJob(WebClient webClient, int initialJobCount, int timeout) {
        return WebClientUtils.waitForJSJob(null, webClient, initialJobCount, timeout);
    }

    public static int waitForJSJob(String message, WebClient webClient, int initialJobCount, long timeout) {
        return WebClientUtils.waitForJSJob(message, webClient, initialJobCount, timeout, defaultCheckInterval);
    }

    public static int waitForJSJob(String message, WebClient webClient, int initialJobCount, int timeout) {
        return WebClientUtils.waitForJSJob(message, webClient, initialJobCount, timeout, defaultCheckInterval);
    }

    public static int waitForJSJob(String message, WebClient webClient, int initialJobCount, long timeout, long checkInterval) {
        int jobs;
        long startTime = System.currentTimeMillis();
        do {
            jobs = webClient.waitForBackgroundJavaScript(checkInterval);
            if (startTime + timeout >= System.currentTimeMillis()) continue;
            throw new RuntimeException("Number of JavaScript jobs doesn't drop to initial level for " + timeout + " seconds. It's memory leak in your JavaScript rather then request taking so long!");
        } while (jobs > initialJobCount);
        System.out.println("Waiting" + (message == null ? "" : " for " + message) + " took: " + (System.currentTimeMillis() - startTime) + "ms");
        return jobs;
    }

    private WebClientUtils() {
    }
}

