/*
 * Decompiled with CFR 0.152.
 */
package pl.com.it_crowd.utils.config;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import pl.com.it_crowd.utils.config.InvalidConfigurationException;
import pl.com.it_crowd.utils.config.PBEHelper;
import pl.com.it_crowd.utils.config.PBESpec;
import pl.com.it_crowd.utils.config.Setting;
import pl.com.it_crowd.utils.config.SettingDAO;
import pl.com.it_crowd.utils.config.converter.SettingConverter;

public abstract class ApplicationConfig
implements Serializable {
    private PBEHelper pbeHelper;
    @Inject
    protected Instance<PBESpec> pbeSpecInstance;
    @Inject
    protected SettingDAO settingDAO;

    @PostConstruct
    protected void init() {
        if (!this.pbeSpecInstance.isUnsatisfied()) {
            PBESpec spec = (PBESpec)this.pbeSpecInstance.get();
            this.pbeHelper = new PBEHelper(spec.getAlgorithm(), spec.getPassword(), spec.getSalt(), spec.getIterationCount());
        }
    }

    protected String load(Enum id) {
        return this.load(id.name());
    }

    protected String load(String id) {
        Setting setting = this.settingDAO.load(id);
        if (setting == null) {
            throw new InvalidConfigurationException(String.format("Missing %s setting", id));
        }
        return setting.getValue();
    }

    protected <T> T load(String id, SettingConverter<T> converter) {
        String stringValue = this.load(id);
        return converter.getObject(stringValue);
    }

    protected <T> T load(Enum id, SettingConverter<T> converter) {
        return this.load(id.name(), converter);
    }

    protected String loadAndDecrypt(Enum id) {
        return this.loadAndDecrypt(id.name());
    }

    protected String loadAndDecrypt(String id) {
        String value = this.load(id);
        return this.getPbeHelper().decrypt(value);
    }

    protected boolean save(Setting setting) {
        this.settingDAO.save(setting);
        return true;
    }

    protected boolean save(String id, String value) {
        return this.save(new Setting(id, value));
    }

    protected boolean save(Enum id, String value) {
        return this.save(id.name(), value);
    }

    protected boolean saveEncrypted(Setting setting) {
        setting.setValue(this.getPbeHelper().encrypt(setting.getValue()));
        return this.save(setting);
    }

    protected boolean saveEncrypted(String id, String value) {
        return this.saveEncrypted(new Setting(id, value));
    }

    protected boolean saveEncrypted(Enum id, String value) {
        return this.saveEncrypted(id.name(), value);
    }

    protected PBEHelper getPbeHelper() {
        if (this.pbeHelper == null) {
            throw new IllegalStateException("Encryption not supported due to lack of PBESpec");
        }
        return this.pbeHelper;
    }
}

