/*
 * Decompiled with CFR 0.152.
 */
package pl.com.it_crowd.utils.config;

import javax.annotation.PostConstruct;
import javax.enterprise.inject.Alternative;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import pl.com.it_crowd.utils.config.InvalidConfigurationException;
import pl.com.it_crowd.utils.config.PBESpec;

@Alternative
public class PBESpecImpl
implements PBESpec {
    private String algorithm;
    private String algorithmJNDI;
    private int iterationCount;
    private String iterationCountJNDI;
    private String password;
    private String passwordJNDI;
    private String salt;
    private String saltJNDI;

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getSalt() {
        return this.salt;
    }

    @PostConstruct
    private void init() throws NamingException {
        if (StringUtils.isBlank((String)this.algorithmJNDI) || StringUtils.isBlank((String)this.iterationCountJNDI) || StringUtils.isBlank((String)this.passwordJNDI) || StringUtils.isBlank((String)this.saltJNDI)) {
            throw new InvalidConfigurationException("One of attributes algorithmJNDI,iterationCountJNDI,passwordJNDI,saltJNDI is missing");
        }
        InitialContext context = new InitialContext();
        try {
            this.algorithm = (String)context.lookup(this.algorithmJNDI);
            this.iterationCount = Integer.parseInt((String)context.lookup(this.iterationCountJNDI));
            this.password = (String)context.lookup(this.passwordJNDI);
            this.salt = (String)context.lookup(this.saltJNDI);
        }
        catch (NamingException e) {
            throw new InvalidConfigurationException("One of attributes algorithmJNDI,iterationCountJNDI,passwordJNDI,saltJNDI is invalid", e);
        }
        catch (NumberFormatException e) {
            throw new InvalidConfigurationException("IterationCount is not a number", e);
        }
    }
}

