/*
 * Decompiled with CFR 0.152.
 */
package pl.com.it_crowd.utils.faces;

import java.io.IOException;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.el.ValueReference;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.FacesComponent;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIMessage;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.context.FacesContext;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.ajax4jsf.component.AjaxClientBehavior;
import org.richfaces.component.UIStatus;
import pl.com.it_crowd.utils.faces.ValueExpressionAnalyzer;

@FacesComponent(value="pl.com.it_crowd.utils.faces.UIInputContainer")
public class UIInputContainer
extends UIComponentBase
implements NamingContainer {
    public static final String COMPONENT_TYPE = "pl.com.it_crowd.utils.faces.UIInputContainer";
    protected static final String HTML_CLASS_ATTR_NAME = "class";
    protected static final String HTML_ID_ATTR_NAME = "id";
    protected static final String HTML_STYLE_ATTR_NAME = "style";
    private static final Logger LOGGER = Logger.getLogger(UIInputContainer.class.getCanonicalName());
    protected boolean beanValidationPresent = this.isClassPresent("javax.validation.Validator");

    public void encodeBegin(FacesContext context) throws IOException {
        String name;
        if (!this.isRendered()) {
            return;
        }
        super.encodeBegin(context);
        InputContainerElements elements = this.scan(this.getFacet("javax.faces.component.COMPOSITE_FACET_NAME"), null, context);
        if (elements.ajaxStatus != null && ((name = elements.ajaxStatus.getName()) == null || "".equals(name.trim()))) {
            elements.ajaxStatus.setName(elements.ajaxStatus.getClientId(context));
        }
        this.wire(elements, context);
        this.getAttributes().put(this.getElementsAttributeName(), elements);
        Object ajaxAttributeValue = this.getAttributes().get(this.getAjaxAttributeName());
        boolean ajax = Boolean.parseBoolean(ajaxAttributeValue == null ? "true" : ajaxAttributeValue.toString());
        if (!elements.ajaxClientBehaviors.isEmpty() && elements.ajaxStatus != null && ajax) {
            this.getAttributes().put(this.getAjaxAttributeName(), true);
        }
        if (elements.hasValidationError()) {
            this.getAttributes().put(this.getInvalidAttributeName(), true);
        } else {
            this.getAttributes().put(this.getInvalidAttributeName(), false);
        }
        if (!this.getAttributes().containsKey(this.getRequiredAttributeName()) && elements.hasRequiredInput()) {
            this.getAttributes().put(this.getRequiredAttributeName(), true);
        }
        if (this.getValueExpression(this.getLabelAttributeName()) == null && (!this.getAttributes().containsKey(this.getLabelAttributeName()) || this.labelHasEmptyValue(elements))) {
            this.getAttributes().put(this.getLabelAttributeName(), this.generateLabel(elements, context));
        }
        if (Boolean.TRUE.equals(this.getAttributes().get(this.getEncloseAttributeName()))) {
            this.startContainerElement(context);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        super.encodeEnd(context);
        if (Boolean.TRUE.equals(this.getAttributes().get(this.getEncloseAttributeName()))) {
            this.endContainerElement(context);
        }
    }

    public String getAjaxAttributeName() {
        return "ajax";
    }

    public String getContainerElementName() {
        return "div";
    }

    public String getElementsAttributeName() {
        return "elements";
    }

    public String getEncloseAttributeName() {
        return "enclose";
    }

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    public String getInvalidAttributeName() {
        return "invalid";
    }

    public String getLabelAttributeName() {
        return "label";
    }

    public String getRequiredAttributeName() {
        return "required";
    }

    protected void endContainerElement(FacesContext context) throws IOException {
        context.getResponseWriter().endElement(this.getContainerElementName());
    }

    protected String generateLabel(InputContainerElements elements, FacesContext context) {
        String name = this.getId().startsWith("j_id") ? elements.getPropertyName(context) : this.getId();
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private Validator getDefaultValidator(FacesContext context) throws FacesException {
        ValidatorFactory validatorFactory;
        if (!this.beanValidationPresent) {
            return null;
        }
        Object cachedObject = context.getExternalContext().getApplicationMap().get("javax.faces.validator.beanValidator.ValidatorFactory");
        if (cachedObject instanceof ValidatorFactory) {
            validatorFactory = (ValidatorFactory)cachedObject;
        } else {
            try {
                validatorFactory = Validation.buildDefaultValidatorFactory();
            }
            catch (ValidationException e) {
                throw new FacesException("Could not build a default Bean Validator factory", (Throwable)e);
            }
            context.getExternalContext().getApplicationMap().put("javax.faces.validator.beanValidator.ValidatorFactory", validatorFactory);
        }
        return validatorFactory.getValidator();
    }

    private boolean isClassPresent(String fqcn) {
        try {
            if (Thread.currentThread().getContextClassLoader() != null) {
                return Thread.currentThread().getContextClassLoader().loadClass(fqcn) != null;
            }
            return Class.forName(fqcn) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    private boolean labelHasEmptyValue(InputContainerElements elements) {
        HtmlOutputLabel label = elements.getLabel();
        Object value = label == null ? null : label.getValue();
        String trimmedLabelValue = value == null ? null : value.toString().trim();
        return label != null && value != null && (trimmedLabelValue.equals(":") || trimmedLabelValue.equals(""));
    }

    protected InputContainerElements scan(UIComponent component, InputContainerElements elements, FacesContext context) {
        if (elements == null) {
            elements = new InputContainerElements();
        }
        if (elements.getLabel() == null && component instanceof HtmlOutputLabel) {
            elements.setLabel((HtmlOutputLabel)component);
        } else if (component instanceof EditableValueHolder) {
            elements.registerInput((EditableValueHolder)component, this.getDefaultValidator(context), context);
        } else if (component instanceof UIMessage) {
            elements.registerMessage((UIMessage)component);
        }
        if (component instanceof ClientBehaviorHolder) {
            for (List behaviors : ((ClientBehaviorHolder)component).getClientBehaviors().values()) {
                for (ClientBehavior behavior : behaviors) {
                    if (!(behavior instanceof AjaxClientBehavior)) continue;
                    elements.registerAjaxClientBehavior((AjaxClientBehavior)behavior);
                }
            }
        }
        if (component instanceof UIStatus) {
            elements.registerAjaxStatus((UIStatus)component);
        }
        for (UIComponent child : component.getChildren()) {
            this.scan(child, elements, context);
        }
        return elements;
    }

    protected void startContainerElement(FacesContext context) throws IOException {
        String styleClass;
        String style;
        context.getResponseWriter().startElement(this.getContainerElementName(), (UIComponent)this);
        String string = style = this.getAttributes().get(HTML_STYLE_ATTR_NAME) != null ? this.getAttributes().get(HTML_STYLE_ATTR_NAME).toString().trim() : null;
        if (style != null && style.length() > 0) {
            context.getResponseWriter().writeAttribute(HTML_STYLE_ATTR_NAME, (Object)style, HTML_STYLE_ATTR_NAME);
        }
        String string2 = styleClass = this.getAttributes().get("styleClass") != null ? this.getAttributes().get("styleClass").toString().trim() : null;
        if (styleClass != null && styleClass.length() > 0) {
            context.getResponseWriter().writeAttribute(HTML_CLASS_ATTR_NAME, (Object)styleClass, HTML_CLASS_ATTR_NAME);
        }
        context.getResponseWriter().writeAttribute(HTML_ID_ATTR_NAME, (Object)this.getClientId(context), HTML_ID_ATTR_NAME);
    }

    protected void wire(InputContainerElements elements, FacesContext context) {
        elements.wire(context);
    }

    public static class InputContainerElements {
        private List<AjaxClientBehavior> ajaxClientBehaviors = new ArrayList<AjaxClientBehavior>();
        private UIStatus ajaxStatus;
        private final List<EditableValueHolder> inputs = new ArrayList<EditableValueHolder>();
        private HtmlOutputLabel label;
        private final List<UIMessage> messages = new ArrayList<UIMessage>();
        private String propertyName;
        private boolean requiredInput = false;
        private boolean validationError = false;

        public HtmlOutputLabel getLabel() {
            return this.label;
        }

        public void setLabel(HtmlOutputLabel label) {
            this.label = label;
        }

        public boolean hasRequiredInput() {
            return this.requiredInput;
        }

        public boolean hasValidationError() {
            return this.validationError;
        }

        public String getPropertyName(FacesContext context) {
            if (this.propertyName != null) {
                return this.propertyName;
            }
            if (this.inputs.size() == 0) {
                return null;
            }
            this.propertyName = (String)new ValueExpressionAnalyzer(((UIComponent)this.inputs.get(0)).getValueExpression("value")).getValueReference(context.getELContext()).getProperty();
            return this.propertyName;
        }

        public void registerAjaxClientBehavior(AjaxClientBehavior component) {
            this.ajaxClientBehaviors.add(component);
        }

        public void registerAjaxStatus(UIStatus component) {
            if (this.ajaxStatus != null) {
                LOGGER.warning("Ajax status already registered");
                return;
            }
            this.ajaxStatus = component;
        }

        public void registerInput(EditableValueHolder input, Validator validator, FacesContext context) {
            this.inputs.add(input);
            if (input.isRequired() || this.isRequiredByConstraint(input, validator, context)) {
                this.requiredInput = true;
            }
            if (!input.isValid()) {
                this.validationError = true;
            } else if (!this.validationError) {
                Iterator it = context.getMessages(((UIComponent)input).getClientId(context));
                while (it.hasNext()) {
                    if (((FacesMessage)it.next()).getSeverity().compareTo((Object)FacesMessage.SEVERITY_WARN) < 0) continue;
                    this.validationError = true;
                    break;
                }
            }
        }

        public void registerMessage(UIMessage message) {
            this.messages.add(message);
        }

        public void wire(FacesContext context) {
            int numInputs = this.inputs.size();
            if (numInputs > 0) {
                if (this.label != null) {
                    this.label.setFor(((UIComponent)this.inputs.get(0)).getClientId(context));
                }
                int len = this.messages.size();
                for (int i = 0; i < len; ++i) {
                    if (i >= numInputs) continue;
                    this.messages.get(i).setFor(((UIComponent)this.inputs.get(i)).getClientId(context));
                }
            }
            if (this.ajaxStatus != null) {
                for (AjaxClientBehavior behavior : this.ajaxClientBehaviors) {
                    behavior.setStatus(this.ajaxStatus.getName());
                }
            }
        }

        private boolean isRequiredByConstraint(EditableValueHolder input, Validator validator, FacesContext context) {
            ValueExpressionAnalyzer valueExpressionAnalyzer;
            ValueReference vref;
            if (validator == null) {
                return false;
            }
            ValueExpression valueExpression = ((UIComponent)input).getValueExpression("value");
            if (valueExpression != null && (vref = (valueExpressionAnalyzer = new ValueExpressionAnalyzer(valueExpression)).getValueReference(context.getELContext())) != null) {
                BeanDescriptor constraintsForClass = validator.getConstraintsForClass(vref.getBase().getClass());
                PropertyDescriptor d = constraintsForClass.getConstraintsForProperty((String)vref.getProperty());
                if (d != null) {
                    Set constraints = d.findConstraints().declaredOn(new ElementType[]{ElementType.FIELD}).unorderedAndMatchingGroups(new Class[]{Default.class}).getConstraintDescriptors();
                    for (ConstraintDescriptor constraint : constraints) {
                        if (!constraint.getAnnotation().annotationType().equals(NotNull.class)) continue;
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
    }
}

