/*
 * Decompiled with CFR 0.152.
 */
package pl.com.it_crowd.utils.test;

import java.io.File;

public final class LibraryResolver {
    public static final String DEFAULT_LIBRARY_DIRECTORY = "target/test-libs";
    public static final String LIBRARY_DIRECTORY_PROPERTY = "test.library.dir";

    private static File getLibraryDirectory() {
        String directoryName = System.getProperty(LIBRARY_DIRECTORY_PROPERTY, DEFAULT_LIBRARY_DIRECTORY);
        File file = new File(directoryName);
        if (!file.isDirectory()) {
            throw new IllegalStateException(String.format("%s does not exist or is not a directory", file.getAbsolutePath()));
        }
        return file;
    }

    public static File resolve(String resourceName) {
        return new File(LibraryResolver.getLibraryDirectory(), resourceName + (resourceName.endsWith(".jar") ? "" : ".jar"));
    }

    private LibraryResolver() {
    }
}

